local assets=
{
	Asset("ANIM", "anim/rpgsword.zip"),
	Asset("ANIM", "anim/swap_rpgsword.zip"),
     Asset("IMAGE", "images/inventoryimages/rpgsword.tex"),
     Asset("ATLAS", "images/inventoryimages/rpgsword.xml"),
    
}

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_rpgsword", "swap_nightmaresword")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end


local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("nightmaresword")
    inst.AnimState:SetBuild("rpgsword")
    inst.AnimState:PlayAnimation("idle")
    
	inst:AddTag("sharp")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.SPIKE_DAMAGE * 0.5)
    
    -------

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/rpgsword.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	


	
	inst:AddComponent("characterspecific")
    inst.components.characterspecific:SetOwner("wod")
	
    return inst
end

return Prefab( "common/inventory/rpgsword", fn, assets) 
